/*
 * Decompiled with CFR 0.152.
 */
package toni.immersivemessages;

import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.client.player.LocalPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import toni.immersivemessages.IMClient;
import toni.immersivemessages.ImmersiveMessagesCommands;
import toni.immersivemessages.ImmersiveMessagesManager;
import toni.immersivemessages.api.ImmersiveMessage;
import toni.immersivemessages.config.AllConfigs;
import toni.immersivemessages.networking.TooltipPacket;
import toni.lib.animation.AnimationTimeline;

@Mod(value="immersivemessages")
public class ImmersiveMessages {
    public static final String MODNAME = "Immersive Messages";
    public static final String ID = "immersivemessages";
    public static final Logger LOGGER = LogManager.getLogger((String)"Immersive Messages");
    private AnimationTimeline animation;

    public ImmersiveMessages() {
        FMLJavaModLoadingContext context = FMLJavaModLoadingContext.get();
        IEventBus modEventBus = context.getModEventBus();
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::clientSetup);
        IMClient.SOUNDS.register(modEventBus);
        AllConfigs.register((type, spec) -> ModLoadingContext.get().registerConfig(type, (IConfigSpec)spec));
    }

    public static void showToPlayer(LocalPlayer player, ImmersiveMessage tooltip) {
        ImmersiveMessagesManager.showToPlayer(player, tooltip);
    }

    public void onInitialize() {
        TooltipPacket.register();
        ImmersiveMessagesCommands.register();
    }

    public void onInitializeClient() {
        IMClient.init();
        TooltipPacket.registerClient();
        HudRenderCallback.EVENT.register(ImmersiveMessagesManager::render);
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        this.onInitialize();
    }

    public void clientSetup(FMLClientSetupEvent event) {
        this.onInitializeClient();
    }

    public static boolean isDedicatedServer() {
        return FMLLoader.getDist() == Dist.DEDICATED_SERVER;
    }
}

